# the autosyncwizard geomodel tab

			group geomodelpage {
				title above center "Geometric Model";
				geometry 0, 0, 650, 378;
				lock top, bottom, left, right;
				
				textnumber rmsthresh;
				group dtmgroup;
				group projectivegroup;
				group specificmodelgroup;
				radiobutton dtmsource;
				radiobutton dtmsource2;
				popuplist elevunits;
				group verticalcrsgroup;

				label geomodelpageinfo {
					value "Specify the geometric model for your output images.";
					geometry 5, 5, 600, 26;
					lock top, left, width, height;
				}

				popuplist adjmethod {
					title left center "Output Geometric Model Type:";
					geometry 15, 40, 370, 26;
					lock top, left, width, height;
					info "Select geometric model for output images";
					titleoffset 165 noalign;
					titlelist {
						"Affine",
						"Polynomial",
						"Linear Rubber Sheeting",
						"Nonlinear Rubber Sheeting",
						"Direct Linear Transform (DLT)",
						"Projective Transform",
						"Same as Input Image (ROP/RPC)",
						"Specific Sensor Model"
					};
					names {
						"Affine",
						"Polynomial",
						"Linear Rubber Sheeting",
						"Nonlinear Rubber Sheeting",
						"Direct Linear Transform (DLT)",
						"Projective Transform",
						"Same as Input Image",
						"Specific Sensor Model"
					};
					on valuechanged {
						hide dtmgroup;
						hide verticalcrsgroup;
						hide projectivegroup;
						hide specificmodelgroup;
						
						if ($adjmethod == "Affine") {
							hide polyorder;
							enable rmsthresh;
						}
						else if ($adjmethod == "Polynomial") {
							show polyorder;
							enable rmsthresh;
						}
						else if ($adjmethod == "Linear Rubber Sheeting") {
							hide polyorder;
							disable rmsthresh;
						}
						else if ($adjmethod == "Nonlinear Rubber Sheeting") {
							hide polyorder;
							disable rmsthresh;
						}
						else if ($adjmethod == "Direct Linear Transform (DLT)") {
							hide polyorder;
							disable rmsthresh;
							show dtmgroup;
							enable dtmgroup;
							hide dtmsource;
							show dtmsource2;
							hide ProjectiveMinZ;
							hide ProjectiveMaxZ;
							SetDTMSource($realdtmsource);
						}
						else if ($adjmethod == "Projective Transform") {
							hide polyorder;
							disable rmsthresh;
							show dtmgroup;
							show ProjectiveMinZ;
							show ProjectiveMaxZ;
							
							if ($Projective2D == 1)
							{
								disable dtmgroup;
								set dtmsource = "constant";
								hide dtmsource2;
								show dtmsource;
								hide verticalcrsgroup;
							}
							else
							{
								hide dtmsource;
								show dtmsource2;
								show verticalcrsgroup;
							}
							SetDTMSource($realdtmsource);
							show projectivegroup;
						}
						else if ($adjmethod == "Same as Input Image") {
							hide polyorder;
							disable rmsthresh;
							show dtmgroup;
							show verticalcrsgroup;
							enable dtmgroup;
							hide ProjectiveMinZ;
							hide ProjectiveMaxZ;
							show dtmsource;
							hide dtmsource2;
							enable dtmsource;
						}
						else if ($adjmethod == "Specific Sensor Model")
						{
							show specificmodelgroup;
							hide polyorder;
							if (GetModelNeedsVCS() == 0)
							{
								hide verticalcrsgroup;
							}
							else
							{
								show verticalcrsgroup;
							}
						}
					}
					
					on input {
						if ($adjmethod == "Affine") {
							SetOutputGeometricModel("Affine");
						}
						else if ($adjmethod == "Polynomial") {
							SetOutputGeometricModel("Polynomial",$polyorder);
						}
						else if ($adjmethod == "Linear Rubber Sheeting") {
							SetOutputGeometricModel("Rubber Sheeting","Linear");
						}
						else if ($adjmethod == "Nonlinear Rubber Sheeting") {
							SetOutputGeometricModel("Rubber Sheeting","Nonlinear");
						}
						else if ($adjmethod == "Direct Linear Transform (DLT)") {
							SetOutputGeometricModel("Direct Linear Transform (DLT)");
							set dtmfileunits = GetDEMVerticalUnits ("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
							if (isEmpty ($dtmfileunits) == 0) {
								set dtmsource2 = "elevation library";
							}
							else {
								set dtmsource2 = "database";
							}
						}
						else if ($adjmethod == "Projective Transform" ) {
							SetOutputGeometricModel("Projective Transform",
								$ProjectiveMinZ, $ProjectiveMaxZ, $samedenpart, $Projective2D, $Order);
							if ($Projective2D == 0)
							{
								set dtmfileunits = GetDEMVerticalUnits ("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
								if (isEmpty ($dtmfileunits) == 0) {
									set dtmsource2 = "elevation library";
								}
								else {
									set dtmsource2 = "database";
								}
							}
						}
						else if ($adjmethod == "Same as Input Image") {
							SetOutputGeometricModel("Same as Input Image");
							set dtmfileunits = GetDEMVerticalUnits ("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
							if (isEmpty ($dtmfileunits) == 0) {
								set dtmsource = "elevation library";
							}
							else {
								set dtmsource = $prevdtmsource;
							}
						}
						else if ($adjmethod == "Specific Sensor Model")
						{
							SetOutputGeometricModel("Specific Sensor Model");
							if ( PopupModelList() == "failed")
							{
								set adjmethod = "Affine";
							}
						}
					}
				}

				textnumber polyorder {
					title left center "Maximum Polynomial Order:";
					info "Maximal order of polynomial to use";
					lock top,left,width,height;
					geometry 415,40,200,26;
					titleoffset 150 noalign;
					min 1;
					max 99;
					value 3;
					on input {
						SetOutputGeometricModel("Polynomial",$polyorder);
					}
				}

				textnumber rmsthresh {
					title left center "RMS Threshold:";
					geometry 15, 75, 368, 26;
					lock top, left, width, height;
					info "Specify maximum acceptable RMS error for syncing output images";
					titleoffset 165 noalign;
					min 0;
					max 999.9999;
					format "8.4";
					on input {
						SetOutputRMSThreshold($rmsthresh);
					}
				}
					
				group dtmgroup {
					geometry 15, 115, 620, 125;
					lock top, bottom, left, right;
					bordertype none;
					textnumber dtmconstant;
					filename dtmfilechooser;

					radiobutton dtmsource {
						title left center "DTM Source:";
						geometry 0, 0, 500, 20;
						lock top, left, width, height;
						info "Select to specify a constant value for elevation or a DTM.";
						layout horizontal;
						titleoffset 162 noalign;
						titlelist {
							"Constant Value",
							"DTM File",
							"Elevation Library"
						};
						options {
							"constant",
							"database",
							"elevation library"
						};
						
						on valuechanged {
							if ($dtmsource == "constant") {
								show dtmconstant;
								hide dtmfilechooser;
								set realdtmsource = $dtmsource;
							}
							else if ($dtmsource == "database") {
								show dtmfilechooser;
								hide dtmconstant;
								set realdtmsource = $dtmsource;
							}
							else {
								set dtmfileunits = GetDEMVerticalUnits ("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
								if (isEmpty ($dtmfileunits)) {
									message ("Elevation Library is not configured properly.  Please run the Elevation Library Manager and try again.");
									set dtmsource = $prevdtmsource;
								}
								else {
									set realdtmsource = "database";
									SetDTMFile("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
									hide dtmconstant;
									set dtmfilechooser = "$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl";
									hide dtmfilechooser;
									SetDTMUnits($dtmfileunits);
									hide elevunits;
								}
							}
							set prevdtmsource = $dtmsource;
							SetDTMSource($realdtmsource);
						}
						on input {
							if ($dtmsource == "constant" OR $dtmsource == "database") {
								set realdtmsource = $dtmsource;
							}
							else {
								set realdtmsource = "database";
							}
							SetDTMSource($realdtmsource);
							updatefinishandbatchbuttons();
						}
					}
					
					radiobutton dtmsource2 {
						title left center "DTM Source:";
						geometry 0, 0, 500, 20;
						lock top, left, width, height;
						info "Select to specify a DTM.";
						layout horizontal;
						titleoffset 162 noalign;
						titlelist {
							"DTM File",
							"Elevation Library"
						};
						options {
							"database",
							"elevation library"
						};
						
						on valuechanged {
							if ($dtmsource2 == "database") {
								show dtmfilechooser;
								hide dtmconstant;
								set realdtmsource = $dtmsource2;
							}
							else {
								set dtmfileunits = GetDEMVerticalUnits ("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
								if (isEmpty ($dtmfileunits)) {
									message ("Elevation Library is not configured properly.  Please run the Elevation Library Manager and try again.");
									set dtmsource2 = $realdtmsource;
								}
								else {
									set realdtmsource = "database";
									SetDTMFile("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
									hide dtmconstant;
									set dtmfilechooser = "$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl";
									hide dtmfilechooser;
									SetDTMUnits($dtmfileunits);
									hide elevunits;
								}
							}
							set prevdtmsource = $dtmsource2;
							SetDTMSource($realdtmsource);
						}
						on input {
							if ($dtmsource2 == "database") {
								set realdtmsource = $dtmsource2;
							}
							else {
								set realdtmsource = "database";
							}
							SetDTMSource($realdtmsource);
							updatefinishandbatchbuttons();
						}
					}
					
					
					textnumber dtmconstant {
						title left center "Elevation:";
						geometry 0, 30, 368, 26;
						lock top, left, width, height;
						info "Specify constant elevation value";
						titleoffset 165 noalign;
						min -999999999;
						max 9999999999;
						format "8.4";
						on input {
							SetConstantElevationValue($dtmconstant);
						}
					}
					
					filename dtmfilechooser {
						title left center "DTM File:";
						geometry 0, 30, 390, 26;
						lock top, left, width, height;
						info "Select the elevation source file";
						titleoffset 165 noalign;
						shortform;
						select getpref ("eml" "default_data_path")+"/*.img";
						filetypedef "raster";
						on filenamechoosen {
							if (IsNotValidDEM($dtmfilechooser))
							{
								set dtmfilechooser = "";
							}
							else
							{
								SetDTMFile($dtmfilechooser);
								set dtmfilechooser = "";
								set dtmfilechooser = GetDTMFile();
								set dtmfileunits = GetDEMVerticalUnits ($dtmfilechooser);
								if (isEmpty ($dtmfileunits)) {
									show elevunits;
								}
								else {
									SetDTMUnits($dtmfileunits);
									hide elevunits;
								}
							}
						}
					}
					
						
					popuplist elevunits {
						title left center "Units:";
						geometry 400, 30, 125, 26;
						lock top, left, width, height;
						info "Select Elevation Units";
						titleoffset 40 noalign;
						titlelist {
							"Meters",
							"Feet"
						};
						names {
							"Meters",
							"Feet"
						};
						on input {
							SetDTMUnits($elevunits);
						}
					}
					textnumber ProjectiveMinZ
					{
						title left center "Min Elevation Value:";
						info "Minimal Elevation Value";
						geometry 0, 66, 245,26;
						lock top, left, width, height;
						titleoffset 165 noalign;
						min -999999999;
						max 9999999999;
						format "8.4";
						value 0;
						on input
						{
							SetOutputGeometricModel("Projective Transform",
								$ProjectiveMinZ, $ProjectiveMaxZ, $samedenpart, $Projective2D, $Order);
						}
					}

					textnumber ProjectiveMaxZ
					{
						title left center "Max Elevation Value:";
						info "Maximal Elevation Value";
						geometry 285, 66, 245,26;
						lock top, left, width, height;
						titleoffset 150 noalign;
						min -999999999;
						max 9999999999;
						format "8.4";
						value 0;
						on input
						{
							SetOutputGeometricModel("Projective Transform",
								$ProjectiveMinZ, $ProjectiveMaxZ, $samedenpart, $Projective2D, $Order);
						}
					}
				}
				
				group verticalcrsgroup {
					geometry 7, 231, 340, 140;
					lock left, right, top, bottom;
					bordertype none;
			    	/* Coordinate Reference System group will be dynamically inserted here */
				}
				
				group projectivegroup {
					geometry 362, 222, 285, 142;
					lock top, bottom, left, right;

					checkbox samedenpart 
					{
						title right center "Use same denominator for x and y";
						geometry 0, 0, 280, 26;
						lock top, left, width, height;
						value 1;
						on valuechanged 
						{
							SetOutputGeometricModel("Projective Transform",
								$ProjectiveMinZ, $ProjectiveMaxZ, $samedenpart, $Projective2D, $Order);
						}
						info "Check box for using same denominator for both x and y.";
					}

					checkbox Projective2D
					{
						title right center "2-Dimension Projective Model";
						info "2-D Projective Model (only ground X and Y considered)";
						geometry 0, 40, 280, 26;
						lock top, left, width, height;
						value 0;
						on valuechanged 
						{
							if ($Projective2D == 1)
							{
								disable dtmgroup;
								set dtmsource = "constant";
								hide dtmsource2;
								show dtmsource;
								hide verticalcrsgroup;
							}
							else if ($Projective2D == 0)
							{
								enable dtmgroup;
								hide dtmsource;
								show dtmsource2;
								enable dtmsource2;
								enable ProjectiveMinZ;
								enable ProjectiveMaxZ;	
								show verticalcrsgroup;
							}
							SetDTMSource($realdtmsource);
							SetOutputGeometricModel("Projective Transform",
								$ProjectiveMinZ, $ProjectiveMaxZ, $samedenpart, $Projective2D, $Order,
								"Use2D");

						}
						on input {
							if ($Projective2D == 0)
							{
								set dtmfileunits = GetDEMVerticalUnits ("$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl");
								if (isEmpty ($dtmfileunits) == 0) {
									set dtmsource2 = "elevation library";
								}
								else {
									set dtmsource2 = "database";
								}
							}
						}
					}

					textnumber Order 
					{
						title left center "RPC Order for projective model:";
						info "RPC Order for projective model";
						geometry 0, 80, 280,25;
						lock top, left, width, height;
						titleoffset 210 noalign;
						min 1;
						max 3;
						format "2.0";
						value 1;
						on input
						{
							SetOutputGeometricModel("Projective Transform",
								$ProjectiveMinZ, $ProjectiveMaxZ, $samedenpart, $Projective2D, $Order);
						}
					}
				}
				
				group specificmodelgroup {
					geometry 15, 115, 620, 125;
					lock top, bottom, left, right;
					bordertype none;
					/*label specificmodelname;
					button showproperties;
					button resetspecificmodel;*/
					
					label specificmodelname{
						title left center "Specific Model Name:";
						geometry 0, 0, 450, 20;
						lock top, left, height;
						info "Specific geometric model that is being selected now";
						
						value "";
					}
					
					button showproperties
					{
						title "Set Model Properties";
						geometry 0, 50, 170, 30;
						on mousedown 
						{
							/*set specificmodelname = "aaa";*/
							ShowModelProp();
						}
					}
					
					button resetspecificmodel
					{
						title "Reset Sensor Model";
						geometry 0, 95, 170, 30;
						on mousedown 
						{
							PopupModelList();
						}
					}
				}
				
				on groupdisplay {
					variable modelnames;
					variable modeltitles;
					variable dtmfilename;
					
					hide dtmgroup;
					hide projectivegroup;
					hide specificmodelgroup;
					
					if (isinstalled("imadvan") == 0) {
						set modelnames = {
							"Affine",
							"Polynomial",
							"Linear Rubber Sheeting",
							"Nonlinear Rubber Sheeting"
						};
						set modeltitles = $modelnames;
						$adjmethod.setnameandtitlelist($modelnames,$modeltitles);
					}
					
					setmodelparts();

					set rmsthresh = GetOutputRMSThreshold();
					set realdtmsource = GetDTMSource();
					set dtmfilename = GetDTMFile();
					if ($realdtmsource == "database" && isEmpty ($dtmfilename) == 0) {
						if ($dtmfilename == "$IMAGINE_HOME/etc/GlobalElevationSourceProxy.esl") {
							set dtmsource = "elevation library";
						}
						else {
							set dtmsource = $realdtmsource;
						}
					}
					else {
						set dtmsource = $realdtmsource;
					}
					if ($dtmsource != "constant")
					{
						set dtmsource2 = $dtmsource;
					}
					set prevdtmsource = $dtmsource;
					set dtmfilechooser = $dtmfilename;
					set dtmconstant = GetConstantElevationValue();
					set elevunits = GetDTMUnits();
				}
			}
